** "Climate and the emergence of global income differences"
** by Thomas Barnebeck Andersen (SDU), Carl-Johan Dalgaard (UCPH & CEPR), and Pablo Selaya (UCPH)
** Review of Economic Studies
** January 2016

** Tables 1, 2, 5, 6, 7 in the main text
** Figure 4 in the main text
** Tables A2, A5, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20 in the Supplementary Appendix

** Requires ivreg2, outreg2, fsum user-defined Stata routines, which can be installed or updated by typing:
** ssc install ivreg2, replace
** ssc install ranktest, replace
** ssc install outreg2, replace
** ssc install fsum, replace


clear all
set more off
cap log close
version 10

*** Set the local download directory ***

local dir `c(pwd)'
cd "`dir'"

*** Load the dataset ***

use crosscountry, clear

*** Define sets of controls ***

global c0
global c1  cont_* 
global c21 loglat logelev 
global c22 _Ilat* _Jelev*
global c3  temp_newgecon prec_newgecon
global c4  distc distr logarea Neo 
global c5  ln_agsuit kg_tropsub areaweig

global all1 cont_* loglat logelev temp_newgecon prec_newgecon distc distr logarea Neo ln_agsuit kg_tropsub areaweig 
global all2 cont_* _Ilat* _Jelev* temp_newgecon prec_newgecon distc distr logarea Neo ln_agsuit kg_tropsub areaweig 


*************************
*** TABLES: MAIN TEXT ***
*************************

*** Table 1 ***

local table 1

		reg logrgdpwok loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

	reg logrgdpwok loguvpopw if sample`table', r
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) 
	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 logrgdpwok loguvpopw $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg logrgdpwok loguvpopw $`c' if sample`table', r 
		testparm $`c'
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
		

*** Table 2 ***

local table 2

		reg logrgdpcap loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

	reg logrgdpcap loguvpopw if sample`table', r
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) 
	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 logrgdpcap loguvpopw $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg logrgdpcap loguvpopw $`c' if sample`table', r 
		testparm $`c'
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
		

*** Table 5 ***

local table 5

		reg logcataract loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

	reg logcataract loguvpopw if sample`table', r
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) 
	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 logcataract loguvpopw $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg logcataract loguvpopw $`c' if sample`table', r 
		testparm $`c'
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
		

*** Table 6 ***

local table 6

		reg lpd1 loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample_c1-c3) ti(Table `table') replace 
	
	foreach d in lpd1 lpd1000 lpd1500 {
		ivreg2 `d' loguvpopw $all2 if sample`table', r partial($all2)
		local pr2 = e(r2)
	reg `d' loguvpopw $all2 if sample`table', r
		testparm $all2
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}

	foreach d in lmad1820 lmad1900 lmad1950 {
		ivreg2 `d' loguvpopw $all2, r partial($all2)
		local pr2 = e(r2)
	reg `d' loguvpopw $all2, r 
		testparm $all2
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}

		ivreg2 lmad1950 loguvpopw $all2 if lmad1900!=., r partial($all2)
		local pr2 = e(r2)
	reg lmad1950 loguvpopw $all2 if lmad1900!=., r
		testparm $all2
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		

*** Table 7 ***

local table 7

		reg logrgdpwok fertilityd loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
		ivreg2 fertilityd loguvpopw $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	reg fertilityd loguvpopw $all1 if sample`table', r
		testparm $all1
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
	
	foreach x in loguvpopw fertilityd logcataract "loguvpopw fertilityd logcataract" {
		ivreg2 logrgdpwok `x' $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	reg logrgdpwok `x' $all1 if sample`table', r
		testparm $all1
		local Fp = r(p)
		outreg2 `x' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
	
		ivreg2 logrgdpwok fertilityd (logcataract = loguvpopw) $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	ivreg2 logrgdpwok fertilityd (logcataract = loguvpopw) $all1 if sample`table', r ffirst
		testparm $all1
		local Fp = r(p)
		outreg2 fertilityd logcataract using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',KleibPaapF,`e(rkf)',ARchi2p,`e(archi2p)')
		

*** SUR test - footnote 27 ***

local test footnote27

	sureg (logrgdpcap loguvpopw $all2) (logrgdpwok loguvpopw $all2)
	test [logrgdpcap]loguvpopw = [logrgdpwok]loguvpopw
	

*** Figure 4 ***

local figure 4

	reg lmad1900 loguvpopw $all2, r
	avplot loguvpopw, mlabel(countrycode) yti("log Real GDP per cap, 1900 (Maddison)") xti("log UV | all controls, with lat & elev FEs") ysc(r(-1 1)) ylabel(-1 -.5 0 .5 1) name(Fig4_a, replace) nodraw
	reg lmad1950 loguvpopw $all2 if lmad1900!=., r
	avplot loguvpopw, mlabel(countrycode) yti("log Real GDP per cap, 1950 (Maddison)") xti("log UV | all controls, with lat & elev FEs") ysc(r(-1 1)) ylabel(-1 -.5 0 .5 1) name(Fig4_b, replace) nodraw
	graph combine Fig4_a Fig4_b, saving(Figure4_gdp1900-1950, replace) ysize(2.25) iscale(1) nodraw
	

************************
*** TABLES: APPENDIX ***
************************

*** Table A2 ***

local table A2

		reg loguvpopw $c1 $c21 $c22 $c3 $c4 $c5, r
		gen sample`table' = e(sample)
		outreg2 using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
	reg loguvpopw $`c' if sample`table', r
		if "`c'"=="c22" | "`c'"=="all2" testparm _I*
		if "`c'"=="c22" | "`c'"=="all2" local Fl = r(F)
		if "`c'"=="c22" | "`c'"=="all2" local Fpl = r(p)
		if "`c'"=="c22" | "`c'"=="all2" testparm _J*
		if "`c'"=="c22" | "`c'"=="all2" local Fe = r(F)
		if "`c'"=="c22" | "`c'"=="all2" local Fpe = r(p)
		testparm $`c'
		local Fp = r(p)
		if "`c'"!="c22" & "`c'"!="all2" outreg2 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp')
		if "`c'"=="c22" | "`c'"=="all2" outreg2 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',Fl,`Fl',Fpl,`Fpl',Fe,`Fe',Fpe,`Fpe')
		}
		

*** Table A5 ***

local table A5
	
		reg logrgdpcap loguvpopw $all1, r
		gen sample`table' = e(sample)
		reg dlogs2005 loguvpopw ls_0 $all1 if fertilityd>1870 & fertilityd<2000, r
		gen sample`table'HK = e(sample)
	
	local var0   rgdpwok2004 rgdpch2004 avgUVdamage_wpop cont_* lat elevmean prec_new temp_new area_new distc distr Neo agsuit kg_tropsub areaweig
	local var1   fertilityd fert1960s fert1970s fert1980s fert1990s fert2000s av_fert 
	local var1HK s15_641870 s15_642000 s2005 s15_642010 
	local var2   cataracts_daly2004_all_1559 skincancer_daly2004_all_1559 trachoma_daly2004_all_1559 hivaids_daly2004_all_1559 hookworm_daly2004_all_1559 malaria_daly2004_all_1559 intestinf_daly2004_all_1559 
	local var3   mad1820 mad1900 mad1950 pd1500 pd1000 pd1 
	local var4   ME polrts02 q_rule_law _Rregion* _Wwhoregion* fuel00 gemstones migdist slave_exports fraceuro 
	local var5   distfrontier_cap distfrontier_cen
	
	log using table`table'.xls, replace text
		// Main variables and controls 
		noi fsum `var0' if sample`table', stat(n mean median sd min max) label
		// Fertility and education rates 
		noi fsum `var1' if sample`table', stat(n mean median sd min max) label
		noi fsum `var1HK' if sample`table'HK, stat(n mean median sd min max) label
		// Years (per 100,000 people between 15 and 59, 2004) lost due to disability from the incidence of: 
		noi fsum `var2' if sample`table', stat(n mean median sd min max) label
		// Measures of historical prosperity 
		noi fsum `var3' if sample`table', stat(n mean median sd min max) label
		// Indicators of institutions, natural resources, trust, culture: 
		noi fsum `var4' if sample`table', stat(n mean median sd min max) label
		// Indicators of technology diffusion from the frontier: 
		fsum `var5' if sample`table', stat(n mean median sd min max) label
	log close


*** Table A7 ***

local table A7

		reg logrgdpcap loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach y in logrgdpcap logrgdpwok {
	foreach c in america africa asia europe oceania {
		ivreg2 `y' loguvpopw $all1 if sample`table' & cont_`c'!=1, r partial($all1)
		local pr2 = e(r2)
	reg `y' loguvpopw $all1 if sample`table' & cont_`c'!=1, r
		testparm $all1
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		}
		

*** Table A8 ***

local table A8

		reg logrgdpcap loguvpopw $all2, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach y in logrgdpcap logrgdpwok {
	foreach c in america africa asia europe oceania {
		ivreg2 `y' loguvpopw $all2 if sample`table' & cont_`c'!=1, r partial($all2)
		local pr2 = e(r2)
	reg `y' loguvpopw $all2 if sample`table' & cont_`c'!=1, r
		testparm $all2
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		}
		

*** Table A9 ***

local table A9

		reg logrgdpcap loguvpopw lskin ltrac lhiv lhook lmala lintest $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw lskin ltrac lhiv lhook lmala lintest using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach c in all1 all2 {
	foreach d in lskin ltrac lhiv lhook lmala lintest "lskin ltrac lhiv lhook lmala lintest" {
		ivreg2 logrgdpcap loguvpopw `d' $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg logrgdpcap loguvpopw `d' $`c' if sample`table', r 
		testparm $`c'
		local Fp = r(p)
		outreg2 loguvpopw `d' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		}
		

*** Table A10 ***

local table A10

		reg logrgdpwok loguvpopw lskin ltrac lhiv lhook lmala lintest $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw lskin ltrac lhiv lhook lmala lintest using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach c in all1 all2 {
	foreach d in lskin ltrac lhiv lhook lmala lintest "lskin ltrac lhiv lhook lmala lintest" {
		ivreg2 logrgdpwok loguvpopw `d' $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg logrgdpwok loguvpopw `d' $`c' if sample`table', r 
		testparm $`c'
		local Fp = r(p)
		outreg2 loguvpopw `d' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		}
		

*** Table A11 ***

local table A11

		reg logrgdpcap loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach c in ME polrts02 q_rule _Rregion* _Wwhoregion* fuel00 gemstones migdist slave_exports fraceuro distfrontier_cap distfrontier_cen {
		ivreg2 logrgdpcap loguvpopw `c' $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	reg logrgdpcap loguvpopw `c' $all1 if sample`table', r 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" testparm _*region* 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fr = r(F)
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fpr = r(p)
		testparm $all1
		local Fp = r(p)
		if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2',Fr,`Fr',Fpr,`Fpr')
		if "`c'"!="_Rregion*" & "`c'"!="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		

*** Table A12 ***

local table A12

		reg logrgdpwok loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach c in ME polrts02 q_rule _Rregion* _Wwhoregion* fuel00 gemstones migdist slave_exports fraceuro distfrontier_cap distfrontier_cen {
		ivreg2 logrgdpwok loguvpopw `c' $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	reg logrgdpwok loguvpopw `c' $all1 if sample`table', r 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" testparm _*region* 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fr = r(F)
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fpr = r(p)
		testparm $all1
		local Fp = r(p)
		if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2',Fr,`Fr',Fpr,`Fpr')
		if "`c'"!="_Rregion*" & "`c'"!="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		

*** Table A13 ***

local table A13

		reg logrgdpcap loguvpopw $all2, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach c in ME polrts02 q_rule _Rregion* _Wwhoregion* fuel00 gemstones migdist slave_exports fraceuro distfrontier_cap distfrontier_cen {
		ivreg2 logrgdpcap loguvpopw `c' $all2 if sample`table', r partial($all2)
		local pr2 = e(r2)
	reg logrgdpcap loguvpopw `c' $all2 if sample`table', r 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" testparm _*region* 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fr = r(F)
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fpr = r(p)
		testparm $all2
		local Fp = r(p)
		if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2',Fr,`Fr',Fpr,`Fpr')
		if "`c'"!="_Rregion*" & "`c'"!="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		

*** Table A14 ***

local table A14

		reg logrgdpwok loguvpopw $all2, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
	foreach c in ME polrts02 q_rule _Rregion* _Wwhoregion* fuel00 gemstones migdist slave_exports fraceuro distfrontier_cap distfrontier_cen {
		ivreg2 logrgdpwok loguvpopw `c' $all2 if sample`table', r partial($all2)
		local pr2 = e(r2)
	reg logrgdpwok loguvpopw `c' $all2 if sample`table', r 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" testparm _*region* 
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fr = r(F)
			if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" local Fpr = r(p)
		testparm $all2
		local Fp = r(p)
		if "`c'"=="_Rregion*" | "`c'"=="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2',Fr,`Fr',Fpr,`Fpr')
		if "`c'"!="_Rregion*" & "`c'"!="_Wwhoregion*" outreg2 loguvpopw `c' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',Fp,`Fp',pr2,`pr2')
		}
		

*** Table A15 ***

local table A15

		reg fertilityd loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

	reg fertilityd loguvpopw if sample`table', r
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) 

	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 fertilityd loguvpopw $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg fertilityd loguvpopw $`c' if sample`table', r 
		if "`c'"=="all1" testparm $c21
		if "`c'"=="all1" local Fplel = r(p)
		if "`c'"=="all2" testparm $c22
		if "`c'"=="all2" local Fplefe = r(p)
		testparm $`c'
		local Fp = r(p)
		if "`c'"=="all1" outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplel,`Fplel')
		if "`c'"=="all2" outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplefe,`Fplefe')
		if "`c'"!="all1" & "`c'"!="all2" outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}

		ivreg2 fertilityd loguvpopw $c1 $c3 $c4 $c5 if sample`table', r partial($c1 $c3 $c4 $c5)
		local pr2 = e(r2)
	reg fertilityd loguvpopw $c1 $c3 $c4 $c5 if sample`table', r 
		testparm $c1 $c3 $c4 $c5
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		

*** Table A16 ***

local table A16

		reg logrgdpcap fertilityd loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace
	
		ivreg2 fertilityd loguvpopw $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	reg fertilityd loguvpopw $all1 if sample`table', r
		testparm $all1
		local Fp = r(p)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
	
	foreach x in loguvpopw fertilityd logcataract "loguvpopw fertilityd logcataract" {
		ivreg2 logrgdpcap `x' $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	reg logrgdpcap `x' $all1 if sample`table', r
		testparm $all1
		local Fp = r(p)
		outreg2 `x' using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
	
		ivreg2 logrgdpcap fertilityd (logcataract = loguvpopw) $all1 if sample`table', r partial($all1)
		local pr2 = e(r2)
	ivreg2 logrgdpcap fertilityd (logcataract = loguvpopw) $all1 if sample`table', r ffirst
		testparm $all1
		local Fp = r(p)
		outreg2 fertilityd logcataract using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',KleibPaapF,`e(rkf)',ARchi2p,`e(archi2p)')
		

*** Table A17 ***

local table A17

		reg dlogs2005 loguvpopw ls_0 $all1 if fertilityd>1870 & fertilityd<2000, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

		ivreg2 dlogs2005 loguvpopw ls_0 if sample`table' & fertilityd>1870 & fertilityd<2000, r partial()
		local pr2 = e(r2)
	reg dlogs2005 loguvpopw ls_0 if sample`table' & fertilityd>1870 & fertilityd<2000, r
		outreg2 loguvpopw ls_0 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(pr2,`pr2')

	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 dlogs2005 loguvpopw ls_0 $`c' if sample`table' & fertilityd>1870 & fertilityd<2000, r partial($`c')
		local pr2 = e(r2)
	reg dlogs2005 loguvpopw ls_0 $`c' if sample`table' & fertilityd>1870 & fertilityd<2000, r
		if "`c'"=="all1" testparm $c21
		if "`c'"=="all1" local Fplel = r(p)
		if "`c'"=="all2" testparm $c22
		if "`c'"=="all2" local Fplefe = r(p)
		testparm $`c'
		local Fp = r(p)
		if "`c'"=="all1" outreg2 loguvpopw ls_0 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplel,`Fplel') 
		if "`c'"=="all2" outreg2 loguvpopw ls_0 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplefe,`Fplefe') 
		if "`c'"!="all1" & "`c'"!="all2" outreg2 loguvpopw ls_0 using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
		

*** Table A18 ***

local table A18

		reg av_fert loguvpopw $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

	reg av_fert loguvpopw if sample`table', r
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) 
	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 av_fert loguvpopw $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg av_fert loguvpopw $`c' if sample`table', r 
		if "`c'"=="all1" testparm $c21
		if "`c'"=="all1" local Fplel = r(p)
		if "`c'"=="all2" testparm $c22
		if "`c'"=="all2" local Fplefe = r(p)
		testparm $`c'
		local Fp = r(p)
		if "`c'"=="all1" outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplel,`Fplel') 
		if "`c'"=="all2" outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplefe,`Fplefe') 
		if "`c'"!="all1" & "`c'"!="all2" outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
		

*** Table A19 ***

local table A19

		reg dlogs2005 loguvpopw ls_0 fertilityd $all1 if fertilityd>1870 & fertilityd<2000, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

		ivreg2 dlogs2005 loguvpopw ls_0 fertilityd if sample`table' & fertilityd>1870 & fertilityd<2000, r partial()
		local pr2 = e(r2)
	reg dlogs2005 loguvpopw ls_0 fertilityd if sample`table' & fertilityd>1870 & fertilityd<2000, r
		outreg2 loguvpopw ls_0 fertilityd using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(pr2,`pr2')

	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 dlogs2005 loguvpopw ls_0 fertilityd $`c' if sample`table' & fertilityd>1870 & fertilityd<2000, r partial($`c')
		local pr2 = e(r2)
	reg dlogs2005 loguvpopw ls_0 fertilityd $`c' if sample`table' & fertilityd>1870 & fertilityd<2000, r
		if "`c'"=="all1" testparm $c21
		if "`c'"=="all1" local Fplel = r(p)
		if "`c'"=="all2" testparm $c22
		if "`c'"=="all2" local Fplefe = r(p)
		testparm $`c'
		local Fp = r(p)
		if "`c'"=="all1" outreg2 loguvpopw ls_0 fertilityd using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplel,`Fplel')
		if "`c'"=="all2" outreg2 loguvpopw ls_0 fertilityd using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp',Fplefe,`Fplefe')
		if "`c'"!="all1" & "`c'"!="all2" outreg2 loguvpopw ls_0 fertilityd using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
		

*** Table A20 ***

local table A20

		reg av_fert loguvpopw fertilityd $all1, r
		gen sample`table' = e(sample)
		outreg2 loguvpopw using table`table'.xls, nonot nocon br auto(2) rdec(2) nor2 ct(sample) ti(Table `table') replace

		ivreg2 av_fert loguvpopw fertilityd if sample`table', r partial()
		local pr2 = e(r2)
	reg av_fert loguvpopw fertilityd if sample`table', r
		outreg2 loguvpopw fertilityd using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(pr2,`pr2')

	foreach c in c1 c21 c22 c3 c4 c5 all1 all2 {
		ivreg2 av_fert loguvpopw fertilityd $`c' if sample`table', r partial($`c')
		local pr2 = e(r2)
	reg av_fert loguvpopw fertilityd $`c' if sample`table', r 
		testparm $`c'
		local Fp = r(p)
		outreg2 loguvpopw fertilityd using table`table'.xls, nonot nocon br auto(2) rdec(2) adds(nc,`r(df)',pr2,`pr2',Fp,`Fp')
		}
		


